<?php
/**
 * @package Blox Monochrome
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class('postlisting blox'); ?>>
	<span class="postheading">
		<h3 class="entry-title left"><a href="<?php the_permalink(); ?>" rel="bookmark"><?php the_title(); ?></a></h3>
		<?php edit_post_link( __( 'Edit', 'blox' ), '<span class="edit-link thin left">- ', '</span>' ); ?>
		<?php if ( 'post' == get_post_type() ) : ?>
			<h5 class="right entry-meta light"><?php blox_posted_on(); ?></h5>
		<?php endif; ?>
	</span><!-- .entry-header -->

	<div class="postdetails grid-33">
		<ul>
			<li><?php blox_posted_by() ?></li>
			<li>
				<ul class="clearfix">
					<?php if ( 'post' == get_post_type() ) : // Hide category text for pages on Search ?>
						<?php
							$categories_list = get_the_category_list( '|' );

							if ( $categories_list && blox_categorized_blog() ):
								$categories_exploded = explode('|', $categories_list);
								foreach ($categories_exploded as $key => $value) {
						?>
						<li class="cat-links">
							<?php printf( __( '%1$s', 'blox' ), $value ); ?>
						</li>
						<?php } endif; // End if categories ?>
					<?php endif; // End if 'post' == get_post_type() ?>
				</ul>
			</li>
			<li><?php comments_number() ?></li>
		</ul>
	</div>

	<div class="entry-summary blurb light">
		<?php the_excerpt(); ?>
	</div>

	<div class="tags left">
		<ul>
			<?php if ( 'post' == get_post_type() ) : // Hide tag text for pages on Search ?>
				<?php
					echo get_the_tag_list('<li>','</li><li>','</li>');
				?>
			<?php endif; // End if 'post' == get_post_type() ?>

			<a href="<?php the_permalink(); ?>" class="button right">Read More</a>
		</ul>
	</div>
</article><!-- #post-## -->
